package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ConversionTaskId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelConversionTaskRequest(
    conversionTaskId: ConversionTaskId,
    reasonMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest = {
    import CancelConversionTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest
      .builder()
      .conversionTaskId(
        ConversionTaskId.unwrap(conversionTaskId): java.lang.String
      )
      .optionallyWith(reasonMessage.map(value => value: java.lang.String))(
        _.reasonMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelConversionTaskRequest.ReadOnly =
    zio.aws.ec2.model.CancelConversionTaskRequest.wrap(buildAwsValue())
}
object CancelConversionTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelConversionTaskRequest =
      zio.aws.ec2.model.CancelConversionTaskRequest(
        conversionTaskId,
        reasonMessage.map(value => value)
      )
    def conversionTaskId: ConversionTaskId
    def reasonMessage: Option[String]
    def getConversionTaskId: ZIO[Any, Nothing, ConversionTaskId] =
      ZIO.succeed(conversionTaskId)
    def getReasonMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reasonMessage", reasonMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest
  ) extends zio.aws.ec2.model.CancelConversionTaskRequest.ReadOnly {
    override val conversionTaskId: ConversionTaskId =
      zio.aws.ec2.model.primitives.ConversionTaskId(impl.conversionTaskId())
    override val reasonMessage: Option[String] =
      scala.Option(impl.reasonMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest
  ): zio.aws.ec2.model.CancelConversionTaskRequest.ReadOnly = new Wrapper(impl)
}
