package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttributeBooleanValue(value: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttributeBooleanValue = {
    import AttributeBooleanValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttributeBooleanValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Boolean))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttributeBooleanValue.ReadOnly =
    zio.aws.ec2.model.AttributeBooleanValue.wrap(buildAwsValue())
}
object AttributeBooleanValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttributeBooleanValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttributeBooleanValue =
      zio.aws.ec2.model.AttributeBooleanValue(value.map(value => value))
    def value: Option[Boolean]
    def getValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttributeBooleanValue
  ) extends zio.aws.ec2.model.AttributeBooleanValue.ReadOnly {
    override val value: Option[Boolean] =
      scala.Option(impl.value()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttributeBooleanValue
  ): zio.aws.ec2.model.AttributeBooleanValue.ReadOnly = new Wrapper(impl)
}
