package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VolumeStatusAttachmentStatus(
    ioPerformance: Option[String] = None,
    instanceId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeStatusAttachmentStatus = {
    import VolumeStatusAttachmentStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeStatusAttachmentStatus
      .builder()
      .optionallyWith(ioPerformance.map(value => value: java.lang.String))(
        _.ioPerformance
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeStatusAttachmentStatus.ReadOnly =
    zio.aws.ec2.model.VolumeStatusAttachmentStatus.wrap(buildAwsValue())
}
object VolumeStatusAttachmentStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeStatusAttachmentStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeStatusAttachmentStatus =
      zio.aws.ec2.model.VolumeStatusAttachmentStatus(
        ioPerformance.map(value => value),
        instanceId.map(value => value)
      )
    def ioPerformance: Option[String]
    def instanceId: Option[String]
    def getIoPerformance: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ioPerformance", ioPerformance)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusAttachmentStatus
  ) extends zio.aws.ec2.model.VolumeStatusAttachmentStatus.ReadOnly {
    override val ioPerformance: Option[String] =
      scala.Option(impl.ioPerformance()).map(value => value: String)
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusAttachmentStatus
  ): zio.aws.ec2.model.VolumeStatusAttachmentStatus.ReadOnly = new Wrapper(impl)
}
