package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayMulticastDomainAssociations(
    transitGatewayMulticastDomainId: Option[String] = None,
    transitGatewayAttachmentId: Option[String] = None,
    resourceId: Option[String] = None,
    resourceType: Option[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = None,
    resourceOwnerId: Option[String] = None,
    subnets: Option[Iterable[zio.aws.ec2.model.SubnetAssociation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociations = {
    import TransitGatewayMulticastDomainAssociations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociations
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value => value: java.lang.String)
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly =
    zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations
      .wrap(buildAwsValue())
}
object TransitGatewayMulticastDomainAssociations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations =
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations(
        transitGatewayMulticastDomainId.map(value => value),
        transitGatewayAttachmentId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        resourceOwnerId.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayMulticastDomainId: Option[String]
    def transitGatewayAttachmentId: Option[String]
    def resourceId: Option[String]
    def resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def resourceOwnerId: Option[String]
    def subnets: Option[List[zio.aws.ec2.model.SubnetAssociation.ReadOnly]]
    def getTransitGatewayMulticastDomainId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerId)
    def getSubnets: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SubnetAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("subnets", subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociations
  ) extends zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly {
    override val transitGatewayMulticastDomainId: Option[String] = scala
      .Option(impl.transitGatewayMulticastDomainId())
      .map(value => value: String)
    override val transitGatewayAttachmentId: Option[String] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value => value: String)
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
      )
    override val resourceOwnerId: Option[String] =
      scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override val subnets
        : Option[List[zio.aws.ec2.model.SubnetAssociation.ReadOnly]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SubnetAssociation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociations
  ): zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly =
    new Wrapper(impl)
}
