package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayAssociation(
    transitGatewayRouteTableId: Option[TransitGatewayRouteTableId] = None,
    transitGatewayAttachmentId: Option[TransitGatewayAttachmentId] = None,
    resourceId: Option[String] = None,
    resourceType: Option[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayAssociationState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayAssociation = {
    import TransitGatewayAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayAssociation
      .builder()
      .optionallyWith(
        transitGatewayRouteTableId.map(value =>
          TransitGatewayRouteTableId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableId)
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayAssociation.ReadOnly =
    zio.aws.ec2.model.TransitGatewayAssociation.wrap(buildAwsValue())
}
object TransitGatewayAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayAssociation =
      zio.aws.ec2.model.TransitGatewayAssociation(
        transitGatewayRouteTableId.map(value => value),
        transitGatewayAttachmentId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        state.map(value => value)
      )
    def transitGatewayRouteTableId: Option[TransitGatewayRouteTableId]
    def transitGatewayAttachmentId: Option[TransitGatewayAttachmentId]
    def resourceId: Option[String]
    def resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def state: Option[zio.aws.ec2.model.TransitGatewayAssociationState]
    def getTransitGatewayRouteTableId
        : ZIO[Any, AwsError, TransitGatewayRouteTableId] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableId",
        transitGatewayRouteTableId
      )
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAssociationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAssociation
  ) extends zio.aws.ec2.model.TransitGatewayAssociation.ReadOnly {
    override val transitGatewayRouteTableId
        : Option[TransitGatewayRouteTableId] = scala
      .Option(impl.transitGatewayRouteTableId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayRouteTableId(value)
      )
    override val transitGatewayAttachmentId
        : Option[TransitGatewayAttachmentId] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
      )
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayAssociationState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAssociationState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAssociation
  ): zio.aws.ec2.model.TransitGatewayAssociation.ReadOnly = new Wrapper(impl)
}
