package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TargetGroupsConfig(
    targetGroups: Option[Iterable[zio.aws.ec2.model.TargetGroup]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TargetGroupsConfig = {
    import TargetGroupsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TargetGroupsConfig
      .builder()
      .optionallyWith(
        targetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroups)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TargetGroupsConfig.ReadOnly =
    zio.aws.ec2.model.TargetGroupsConfig.wrap(buildAwsValue())
}
object TargetGroupsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TargetGroupsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TargetGroupsConfig =
      zio.aws.ec2.model.TargetGroupsConfig(
        targetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def targetGroups: Option[List[zio.aws.ec2.model.TargetGroup.ReadOnly]]
    def getTargetGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.TargetGroup.ReadOnly]] =
      AwsError.unwrapOptionField("targetGroups", targetGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TargetGroupsConfig
  ) extends zio.aws.ec2.model.TargetGroupsConfig.ReadOnly {
    override val targetGroups
        : Option[List[zio.aws.ec2.model.TargetGroup.ReadOnly]] = scala
      .Option(impl.targetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TargetGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TargetGroupsConfig
  ): zio.aws.ec2.model.TargetGroupsConfig.ReadOnly = new Wrapper(impl)
}
