package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SpotMarketOptions(
    maxPrice: Option[String] = None,
    spotInstanceType: Option[zio.aws.ec2.model.SpotInstanceType] = None,
    blockDurationMinutes: Option[Integer] = None,
    validUntil: Option[DateTime] = None,
    instanceInterruptionBehavior: Option[
      zio.aws.ec2.model.InstanceInterruptionBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotMarketOptions = {
    import SpotMarketOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotMarketOptions
      .builder()
      .optionallyWith(maxPrice.map(value => value: java.lang.String))(
        _.maxPrice
      )
      .optionallyWith(spotInstanceType.map(value => value.unwrap))(
        _.spotInstanceType
      )
      .optionallyWith(
        blockDurationMinutes.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.blockDurationMinutes)
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(instanceInterruptionBehavior.map(value => value.unwrap))(
        _.instanceInterruptionBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotMarketOptions.ReadOnly =
    zio.aws.ec2.model.SpotMarketOptions.wrap(buildAwsValue())
}
object SpotMarketOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotMarketOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotMarketOptions =
      zio.aws.ec2.model.SpotMarketOptions(
        maxPrice.map(value => value),
        spotInstanceType.map(value => value),
        blockDurationMinutes.map(value => value),
        validUntil.map(value => value),
        instanceInterruptionBehavior.map(value => value)
      )
    def maxPrice: Option[String]
    def spotInstanceType: Option[zio.aws.ec2.model.SpotInstanceType]
    def blockDurationMinutes: Option[Integer]
    def validUntil: Option[DateTime]
    def instanceInterruptionBehavior
        : Option[zio.aws.ec2.model.InstanceInterruptionBehavior]
    def getMaxPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxPrice", maxPrice)
    def getSpotInstanceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotInstanceType] =
      AwsError.unwrapOptionField("spotInstanceType", spotInstanceType)
    def getBlockDurationMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("blockDurationMinutes", blockDurationMinutes)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getInstanceInterruptionBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceInterruptionBehavior] =
      AwsError.unwrapOptionField(
        "instanceInterruptionBehavior",
        instanceInterruptionBehavior
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotMarketOptions
  ) extends zio.aws.ec2.model.SpotMarketOptions.ReadOnly {
    override val maxPrice: Option[String] =
      scala.Option(impl.maxPrice()).map(value => value: String)
    override val spotInstanceType: Option[zio.aws.ec2.model.SpotInstanceType] =
      scala
        .Option(impl.spotInstanceType())
        .map(value => zio.aws.ec2.model.SpotInstanceType.wrap(value))
    override val blockDurationMinutes: Option[Integer] = scala
      .Option(impl.blockDurationMinutes())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val validUntil: Option[DateTime] = scala
      .Option(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val instanceInterruptionBehavior
        : Option[zio.aws.ec2.model.InstanceInterruptionBehavior] = scala
      .Option(impl.instanceInterruptionBehavior())
      .map(value => zio.aws.ec2.model.InstanceInterruptionBehavior.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotMarketOptions
  ): zio.aws.ec2.model.SpotMarketOptions.ReadOnly = new Wrapper(impl)
}
