package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SpotAllocationStrategy {
  def unwrap: software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy
}
object SpotAllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy
  ): zio.aws.ec2.model.SpotAllocationStrategy = value match {
    case software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy.LOWEST_PRICE =>
      val r = `lowest-price`
      r
    case software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy.DIVERSIFIED =>
      val r = diversified
      r
    case software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy.CAPACITY_OPTIMIZED =>
      val r = `capacity-optimized`
      r
    case software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy.CAPACITY_OPTIMIZED_PRIORITIZED =>
      val r = `capacity-optimized-prioritized`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.SpotAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object `lowest-price` extends zio.aws.ec2.model.SpotAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy.LOWEST_PRICE
  }
  case object diversified extends zio.aws.ec2.model.SpotAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy.DIVERSIFIED
  }
  case object `capacity-optimized`
      extends zio.aws.ec2.model.SpotAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy.CAPACITY_OPTIMIZED
  }
  case object `capacity-optimized-prioritized`
      extends zio.aws.ec2.model.SpotAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy =
      software.amazon.awssdk.services.ec2.model.SpotAllocationStrategy.CAPACITY_OPTIMIZED_PRIORITIZED
  }
}
