package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SnapshotDetail(
    description: Option[String] = None,
    deviceName: Option[String] = None,
    diskImageSize: Option[Double] = None,
    format: Option[String] = None,
    progress: Option[String] = None,
    snapshotId: Option[String] = None,
    status: Option[String] = None,
    statusMessage: Option[String] = None,
    url: Option[String] = None,
    userBucket: Option[zio.aws.ec2.model.UserBucketDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SnapshotDetail = {
    import SnapshotDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SnapshotDetail
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(diskImageSize.map(value => value: java.lang.Double))(
        _.diskImageSize
      )
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(userBucket.map(value => value.buildAwsValue()))(
        _.userBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SnapshotDetail.ReadOnly =
    zio.aws.ec2.model.SnapshotDetail.wrap(buildAwsValue())
}
object SnapshotDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SnapshotDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SnapshotDetail =
      zio.aws.ec2.model.SnapshotDetail(
        description.map(value => value),
        deviceName.map(value => value),
        diskImageSize.map(value => value),
        format.map(value => value),
        progress.map(value => value),
        snapshotId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        url.map(value => value),
        userBucket.map(value => value.asEditable)
      )
    def description: Option[String]
    def deviceName: Option[String]
    def diskImageSize: Option[Double]
    def format: Option[String]
    def progress: Option[String]
    def snapshotId: Option[String]
    def status: Option[String]
    def statusMessage: Option[String]
    def url: Option[String]
    def userBucket: Option[zio.aws.ec2.model.UserBucketDetails.ReadOnly]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getDiskImageSize: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("diskImageSize", diskImageSize)
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
    def getUserBucket
        : ZIO[Any, AwsError, zio.aws.ec2.model.UserBucketDetails.ReadOnly] =
      AwsError.unwrapOptionField("userBucket", userBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotDetail
  ) extends zio.aws.ec2.model.SnapshotDetail.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val deviceName: Option[String] =
      scala.Option(impl.deviceName()).map(value => value: String)
    override val diskImageSize: Option[Double] =
      scala.Option(impl.diskImageSize()).map(value => value: Double)
    override val format: Option[String] =
      scala.Option(impl.format()).map(value => value: String)
    override val progress: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val url: Option[String] =
      scala.Option(impl.url()).map(value => value: String)
    override val userBucket
        : Option[zio.aws.ec2.model.UserBucketDetails.ReadOnly] = scala
      .Option(impl.userBucket())
      .map(value => zio.aws.ec2.model.UserBucketDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotDetail
  ): zio.aws.ec2.model.SnapshotDetail.ReadOnly = new Wrapper(impl)
}
