package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServiceTypeDetail(
    serviceType: Option[zio.aws.ec2.model.ServiceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ServiceTypeDetail = {
    import ServiceTypeDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ServiceTypeDetail
      .builder()
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ServiceTypeDetail.ReadOnly =
    zio.aws.ec2.model.ServiceTypeDetail.wrap(buildAwsValue())
}
object ServiceTypeDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ServiceTypeDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ServiceTypeDetail =
      zio.aws.ec2.model.ServiceTypeDetail(serviceType.map(value => value))
    def serviceType: Option[zio.aws.ec2.model.ServiceType]
    def getServiceType: ZIO[Any, AwsError, zio.aws.ec2.model.ServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ServiceTypeDetail
  ) extends zio.aws.ec2.model.ServiceTypeDetail.ReadOnly {
    override val serviceType: Option[zio.aws.ec2.model.ServiceType] = scala
      .Option(impl.serviceType())
      .map(value => zio.aws.ec2.model.ServiceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ServiceTypeDetail
  ): zio.aws.ec2.model.ServiceTypeDetail.ReadOnly = new Wrapper(impl)
}
