package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SecurityGroup(
    description: Option[String] = None,
    groupName: Option[String] = None,
    ipPermissions: Option[Iterable[zio.aws.ec2.model.IpPermission]] = None,
    ownerId: Option[String] = None,
    groupId: Option[String] = None,
    ipPermissionsEgress: Option[Iterable[zio.aws.ec2.model.IpPermission]] =
      None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    vpcId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroup = {
    import SecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroup
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(
        ipPermissionsEgress.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissionsEgress)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroup.ReadOnly =
    zio.aws.ec2.model.SecurityGroup.wrap(buildAwsValue())
}
object SecurityGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.SecurityGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroup =
      zio.aws.ec2.model.SecurityGroup(
        description.map(value => value),
        groupName.map(value => value),
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        groupId.map(value => value),
        ipPermissionsEgress.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def description: Option[String]
    def groupName: Option[String]
    def ipPermissions: Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def ownerId: Option[String]
    def groupId: Option[String]
    def ipPermissionsEgress
        : Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcId: Option[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getIpPermissionsEgress
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("ipPermissionsEgress", ipPermissionsEgress)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroup
  ) extends zio.aws.ec2.model.SecurityGroup.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val ipPermissions
        : Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]] = scala
      .Option(impl.ipPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpPermission.wrap(item)
        }.toList
      )
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val groupId: Option[String] =
      scala.Option(impl.groupId()).map(value => value: String)
    override val ipPermissionsEgress
        : Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]] = scala
      .Option(impl.ipPermissionsEgress())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpPermission.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroup
  ): zio.aws.ec2.model.SecurityGroup.ReadOnly = new Wrapper(impl)
}
