package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  RestoreSnapshotTierRequestTemporaryRestoreDays,
  SnapshotId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreSnapshotTierRequest(
    snapshotId: SnapshotId,
    temporaryRestoreDays: Option[
      RestoreSnapshotTierRequestTemporaryRestoreDays
    ] = None,
    permanentRestore: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest = {
    import RestoreSnapshotTierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest
      .builder()
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .optionallyWith(
        temporaryRestoreDays.map(value =>
          RestoreSnapshotTierRequestTemporaryRestoreDays.unwrap(value): Integer
        )
      )(_.temporaryRestoreDays)
      .optionallyWith(permanentRestore.map(value => value: java.lang.Boolean))(
        _.permanentRestore
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RestoreSnapshotTierRequest.ReadOnly =
    zio.aws.ec2.model.RestoreSnapshotTierRequest.wrap(buildAwsValue())
}
object RestoreSnapshotTierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreSnapshotTierRequest =
      zio.aws.ec2.model.RestoreSnapshotTierRequest(
        snapshotId,
        temporaryRestoreDays.map(value => value),
        permanentRestore.map(value => value)
      )
    def snapshotId: SnapshotId
    def temporaryRestoreDays
        : Option[RestoreSnapshotTierRequestTemporaryRestoreDays]
    def permanentRestore: Option[Boolean]
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
    def getTemporaryRestoreDays
        : ZIO[Any, AwsError, RestoreSnapshotTierRequestTemporaryRestoreDays] =
      AwsError.unwrapOptionField("temporaryRestoreDays", temporaryRestoreDays)
    def getPermanentRestore: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("permanentRestore", permanentRestore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest
  ) extends zio.aws.ec2.model.RestoreSnapshotTierRequest.ReadOnly {
    override val snapshotId: SnapshotId =
      zio.aws.ec2.model.primitives.SnapshotId(impl.snapshotId())
    override val temporaryRestoreDays
        : Option[RestoreSnapshotTierRequestTemporaryRestoreDays] = scala
      .Option(impl.temporaryRestoreDays())
      .map(value =>
        zio.aws.ec2.model.primitives
          .RestoreSnapshotTierRequestTemporaryRestoreDays(value)
      )
    override val permanentRestore: Option[Boolean] =
      scala.Option(impl.permanentRestore()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotTierRequest
  ): zio.aws.ec2.model.RestoreSnapshotTierRequest.ReadOnly = new Wrapper(impl)
}
