package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInterfaceId,
  InstanceId,
  RouteTableId,
  CarrierGatewayId,
  EgressOnlyInternetGatewayId,
  TransitGatewayId,
  CoreNetworkArn,
  NatGatewayId,
  VpcPeeringConnectionId,
  RouteGatewayId,
  VpcEndpointId,
  LocalGatewayId,
  PrefixListResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReplaceRouteRequest(
    destinationCidrBlock: Option[String] = None,
    destinationIpv6CidrBlock: Option[String] = None,
    destinationPrefixListId: Option[PrefixListResourceId] = None,
    vpcEndpointId: Option[VpcEndpointId] = None,
    egressOnlyInternetGatewayId: Option[EgressOnlyInternetGatewayId] = None,
    gatewayId: Option[RouteGatewayId] = None,
    instanceId: Option[InstanceId] = None,
    localTarget: Option[Boolean] = None,
    natGatewayId: Option[NatGatewayId] = None,
    transitGatewayId: Option[TransitGatewayId] = None,
    localGatewayId: Option[LocalGatewayId] = None,
    carrierGatewayId: Option[CarrierGatewayId] = None,
    networkInterfaceId: Option[NetworkInterfaceId] = None,
    routeTableId: RouteTableId,
    vpcPeeringConnectionId: Option[VpcPeeringConnectionId] = None,
    coreNetworkArn: Option[CoreNetworkArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest = {
    import ReplaceRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest
      .builder()
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinationIpv6CidrBlock.map(value => value: java.lang.String)
      )(_.destinationIpv6CidrBlock)
      .optionallyWith(
        destinationPrefixListId.map(value =>
          PrefixListResourceId.unwrap(value): java.lang.String
        )
      )(_.destinationPrefixListId)
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .optionallyWith(
        egressOnlyInternetGatewayId.map(value =>
          EgressOnlyInternetGatewayId.unwrap(value): java.lang.String
        )
      )(_.egressOnlyInternetGatewayId)
      .optionallyWith(
        gatewayId.map(value => RouteGatewayId.unwrap(value): java.lang.String)
      )(_.gatewayId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(localTarget.map(value => value: java.lang.Boolean))(
        _.localTarget
      )
      .optionallyWith(
        natGatewayId.map(value => NatGatewayId.unwrap(value): java.lang.String)
      )(_.natGatewayId)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(
        localGatewayId.map(value =>
          LocalGatewayId.unwrap(value): java.lang.String
        )
      )(_.localGatewayId)
      .optionallyWith(
        carrierGatewayId.map(value =>
          CarrierGatewayId.unwrap(value): java.lang.String
        )
      )(_.carrierGatewayId)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .routeTableId(RouteTableId.unwrap(routeTableId): java.lang.String)
      .optionallyWith(
        vpcPeeringConnectionId.map(value =>
          VpcPeeringConnectionId.unwrap(value): java.lang.String
        )
      )(_.vpcPeeringConnectionId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReplaceRouteRequest.ReadOnly =
    zio.aws.ec2.model.ReplaceRouteRequest.wrap(buildAwsValue())
}
object ReplaceRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceRouteRequest =
      zio.aws.ec2.model.ReplaceRouteRequest(
        destinationCidrBlock.map(value => value),
        destinationIpv6CidrBlock.map(value => value),
        destinationPrefixListId.map(value => value),
        vpcEndpointId.map(value => value),
        egressOnlyInternetGatewayId.map(value => value),
        gatewayId.map(value => value),
        instanceId.map(value => value),
        localTarget.map(value => value),
        natGatewayId.map(value => value),
        transitGatewayId.map(value => value),
        localGatewayId.map(value => value),
        carrierGatewayId.map(value => value),
        networkInterfaceId.map(value => value),
        routeTableId,
        vpcPeeringConnectionId.map(value => value),
        coreNetworkArn.map(value => value)
      )
    def destinationCidrBlock: Option[String]
    def destinationIpv6CidrBlock: Option[String]
    def destinationPrefixListId: Option[PrefixListResourceId]
    def vpcEndpointId: Option[VpcEndpointId]
    def egressOnlyInternetGatewayId: Option[EgressOnlyInternetGatewayId]
    def gatewayId: Option[RouteGatewayId]
    def instanceId: Option[InstanceId]
    def localTarget: Option[Boolean]
    def natGatewayId: Option[NatGatewayId]
    def transitGatewayId: Option[TransitGatewayId]
    def localGatewayId: Option[LocalGatewayId]
    def carrierGatewayId: Option[CarrierGatewayId]
    def networkInterfaceId: Option[NetworkInterfaceId]
    def routeTableId: RouteTableId
    def vpcPeeringConnectionId: Option[VpcPeeringConnectionId]
    def coreNetworkArn: Option[CoreNetworkArn]
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinationIpv6CidrBlock: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("destinationIpv6CidrBlock", destinationIpv6CidrBlock)
    def getDestinationPrefixListId: ZIO[Any, AwsError, PrefixListResourceId] =
      AwsError.unwrapOptionField(
        "destinationPrefixListId",
        destinationPrefixListId
      )
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getEgressOnlyInternetGatewayId
        : ZIO[Any, AwsError, EgressOnlyInternetGatewayId] =
      AwsError.unwrapOptionField(
        "egressOnlyInternetGatewayId",
        egressOnlyInternetGatewayId
      )
    def getGatewayId: ZIO[Any, AwsError, RouteGatewayId] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getLocalTarget: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("localTarget", localTarget)
    def getNatGatewayId: ZIO[Any, AwsError, NatGatewayId] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getLocalGatewayId: ZIO[Any, AwsError, LocalGatewayId] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getCarrierGatewayId: ZIO[Any, AwsError, CarrierGatewayId] =
      AwsError.unwrapOptionField("carrierGatewayId", carrierGatewayId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getRouteTableId: ZIO[Any, Nothing, RouteTableId] =
      ZIO.succeed(routeTableId)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, VpcPeeringConnectionId] =
      AwsError.unwrapOptionField(
        "vpcPeeringConnectionId",
        vpcPeeringConnectionId
      )
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest
  ) extends zio.aws.ec2.model.ReplaceRouteRequest.ReadOnly {
    override val destinationCidrBlock: Option[String] =
      scala.Option(impl.destinationCidrBlock()).map(value => value: String)
    override val destinationIpv6CidrBlock: Option[String] =
      scala.Option(impl.destinationIpv6CidrBlock()).map(value => value: String)
    override val destinationPrefixListId: Option[PrefixListResourceId] = scala
      .Option(impl.destinationPrefixListId())
      .map(value => zio.aws.ec2.model.primitives.PrefixListResourceId(value))
    override val vpcEndpointId: Option[VpcEndpointId] = scala
      .Option(impl.vpcEndpointId())
      .map(value => zio.aws.ec2.model.primitives.VpcEndpointId(value))
    override val egressOnlyInternetGatewayId
        : Option[EgressOnlyInternetGatewayId] = scala
      .Option(impl.egressOnlyInternetGatewayId())
      .map(value =>
        zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId(value)
      )
    override val gatewayId: Option[RouteGatewayId] = scala
      .Option(impl.gatewayId())
      .map(value => zio.aws.ec2.model.primitives.RouteGatewayId(value))
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ec2.model.primitives.InstanceId(value))
    override val localTarget: Option[Boolean] =
      scala.Option(impl.localTarget()).map(value => value: Boolean)
    override val natGatewayId: Option[NatGatewayId] = scala
      .Option(impl.natGatewayId())
      .map(value => zio.aws.ec2.model.primitives.NatGatewayId(value))
    override val transitGatewayId: Option[TransitGatewayId] = scala
      .Option(impl.transitGatewayId())
      .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val localGatewayId: Option[LocalGatewayId] = scala
      .Option(impl.localGatewayId())
      .map(value => zio.aws.ec2.model.primitives.LocalGatewayId(value))
    override val carrierGatewayId: Option[CarrierGatewayId] = scala
      .Option(impl.carrierGatewayId())
      .map(value => zio.aws.ec2.model.primitives.CarrierGatewayId(value))
    override val networkInterfaceId: Option[NetworkInterfaceId] = scala
      .Option(impl.networkInterfaceId())
      .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val routeTableId: RouteTableId =
      zio.aws.ec2.model.primitives.RouteTableId(impl.routeTableId())
    override val vpcPeeringConnectionId: Option[VpcPeeringConnectionId] = scala
      .Option(impl.vpcPeeringConnectionId())
      .map(value => zio.aws.ec2.model.primitives.VpcPeeringConnectionId(value))
    override val coreNetworkArn: Option[CoreNetworkArn] = scala
      .Option(impl.coreNetworkArn())
      .map(value => zio.aws.ec2.model.primitives.CoreNetworkArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest
  ): zio.aws.ec2.model.ReplaceRouteRequest.ReadOnly = new Wrapper(impl)
}
