package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ReplaceRootVolumeTaskState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState
}
object ReplaceRootVolumeTaskState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState
  ): zio.aws.ec2.model.ReplaceRootVolumeTaskState = value match {
    case software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.IN_PROGRESS =>
      val r = `in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.FAILING =>
      val r = failing
      r
    case software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.SUCCEEDED =>
      val r = succeeded
      r
    case software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.FAILED_DETACHED =>
      val r = `failed-detached`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ReplaceRootVolumeTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState =
      software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.ReplaceRootVolumeTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState =
      software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.PENDING
  }
  case object `in-progress`
      extends zio.aws.ec2.model.ReplaceRootVolumeTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState =
      software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.IN_PROGRESS
  }
  case object failing extends zio.aws.ec2.model.ReplaceRootVolumeTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState =
      software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.FAILING
  }
  case object succeeded extends zio.aws.ec2.model.ReplaceRootVolumeTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState =
      software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.SUCCEEDED
  }
  case object failed extends zio.aws.ec2.model.ReplaceRootVolumeTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState =
      software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.FAILED
  }
  case object `failed-detached`
      extends zio.aws.ec2.model.ReplaceRootVolumeTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState =
      software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState.FAILED_DETACHED
  }
}
