package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PurchaseRequest(
    instanceCount: Integer,
    purchaseToken: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PurchaseRequest = {
    import PurchaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PurchaseRequest
      .builder()
      .instanceCount(Integer.unwrap(instanceCount): java.lang.Integer)
      .purchaseToken(purchaseToken: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PurchaseRequest.ReadOnly =
    zio.aws.ec2.model.PurchaseRequest.wrap(buildAwsValue())
}
object PurchaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PurchaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PurchaseRequest =
      zio.aws.ec2.model.PurchaseRequest(instanceCount, purchaseToken)
    def instanceCount: Integer
    def purchaseToken: String
    def getInstanceCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(instanceCount)
    def getPurchaseToken: ZIO[Any, Nothing, String] = ZIO.succeed(purchaseToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseRequest
  ) extends zio.aws.ec2.model.PurchaseRequest.ReadOnly {
    override val instanceCount: Integer =
      zio.aws.ec2.model.primitives.Integer(impl.instanceCount())
    override val purchaseToken: String = impl.purchaseToken(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseRequest
  ): zio.aws.ec2.model.PurchaseRequest.ReadOnly = new Wrapper(impl)
}
