package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVpnConnectionOptionsRequest(
    vpnConnectionId: VpnConnectionId,
    localIpv4NetworkCidr: Option[String] = None,
    remoteIpv4NetworkCidr: Option[String] = None,
    localIpv6NetworkCidr: Option[String] = None,
    remoteIpv6NetworkCidr: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsRequest = {
    import ModifyVpnConnectionOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsRequest
      .builder()
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .optionallyWith(
        localIpv4NetworkCidr.map(value => value: java.lang.String)
      )(_.localIpv4NetworkCidr)
      .optionallyWith(
        remoteIpv4NetworkCidr.map(value => value: java.lang.String)
      )(_.remoteIpv4NetworkCidr)
      .optionallyWith(
        localIpv6NetworkCidr.map(value => value: java.lang.String)
      )(_.localIpv6NetworkCidr)
      .optionallyWith(
        remoteIpv6NetworkCidr.map(value => value: java.lang.String)
      )(_.remoteIpv6NetworkCidr)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpnConnectionOptionsRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpnConnectionOptionsRequest.wrap(buildAwsValue())
}
object ModifyVpnConnectionOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnConnectionOptionsRequest =
      zio.aws.ec2.model.ModifyVpnConnectionOptionsRequest(
        vpnConnectionId,
        localIpv4NetworkCidr.map(value => value),
        remoteIpv4NetworkCidr.map(value => value),
        localIpv6NetworkCidr.map(value => value),
        remoteIpv6NetworkCidr.map(value => value)
      )
    def vpnConnectionId: VpnConnectionId
    def localIpv4NetworkCidr: Option[String]
    def remoteIpv4NetworkCidr: Option[String]
    def localIpv6NetworkCidr: Option[String]
    def remoteIpv6NetworkCidr: Option[String]
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
    def getLocalIpv4NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localIpv4NetworkCidr", localIpv4NetworkCidr)
    def getRemoteIpv4NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remoteIpv4NetworkCidr", remoteIpv4NetworkCidr)
    def getLocalIpv6NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localIpv6NetworkCidr", localIpv6NetworkCidr)
    def getRemoteIpv6NetworkCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("remoteIpv6NetworkCidr", remoteIpv6NetworkCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsRequest
  ) extends zio.aws.ec2.model.ModifyVpnConnectionOptionsRequest.ReadOnly {
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
    override val localIpv4NetworkCidr: Option[String] =
      scala.Option(impl.localIpv4NetworkCidr()).map(value => value: String)
    override val remoteIpv4NetworkCidr: Option[String] =
      scala.Option(impl.remoteIpv4NetworkCidr()).map(value => value: String)
    override val localIpv6NetworkCidr: Option[String] =
      scala.Option(impl.localIpv6NetworkCidr()).map(value => value: String)
    override val remoteIpv6NetworkCidr: Option[String] =
      scala.Option(impl.remoteIpv6NetworkCidr()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsRequest
  ): zio.aws.ec2.model.ModifyVpnConnectionOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
