package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, PrefixListResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyManagedPrefixListRequest(
    prefixListId: PrefixListResourceId,
    currentVersion: Option[Long] = None,
    prefixListName: Option[String] = None,
    addEntries: Option[Iterable[zio.aws.ec2.model.AddPrefixListEntry]] = None,
    removeEntries: Option[Iterable[zio.aws.ec2.model.RemovePrefixListEntry]] =
      None,
    maxEntries: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest = {
    import ModifyManagedPrefixListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest
      .builder()
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .optionallyWith(currentVersion.map(value => value: java.lang.Long))(
        _.currentVersion
      )
      .optionallyWith(prefixListName.map(value => value: java.lang.String))(
        _.prefixListName
      )
      .optionallyWith(
        addEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addEntries)
      .optionallyWith(
        removeEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removeEntries)
      .optionallyWith(
        maxEntries.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxEntries)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyManagedPrefixListRequest.ReadOnly =
    zio.aws.ec2.model.ModifyManagedPrefixListRequest.wrap(buildAwsValue())
}
object ModifyManagedPrefixListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyManagedPrefixListRequest =
      zio.aws.ec2.model.ModifyManagedPrefixListRequest(
        prefixListId,
        currentVersion.map(value => value),
        prefixListName.map(value => value),
        addEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxEntries.map(value => value)
      )
    def prefixListId: PrefixListResourceId
    def currentVersion: Option[Long]
    def prefixListName: Option[String]
    def addEntries: Option[List[zio.aws.ec2.model.AddPrefixListEntry.ReadOnly]]
    def removeEntries
        : Option[List[zio.aws.ec2.model.RemovePrefixListEntry.ReadOnly]]
    def maxEntries: Option[Integer]
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
    def getCurrentVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getPrefixListName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListName", prefixListName)
    def getAddEntries: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AddPrefixListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("addEntries", addEntries)
    def getRemoveEntries: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RemovePrefixListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("removeEntries", removeEntries)
    def getMaxEntries: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxEntries", maxEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest
  ) extends zio.aws.ec2.model.ModifyManagedPrefixListRequest.ReadOnly {
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
    override val currentVersion: Option[Long] =
      scala.Option(impl.currentVersion()).map(value => value: Long)
    override val prefixListName: Option[String] =
      scala.Option(impl.prefixListName()).map(value => value: String)
    override val addEntries
        : Option[List[zio.aws.ec2.model.AddPrefixListEntry.ReadOnly]] = scala
      .Option(impl.addEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AddPrefixListEntry.wrap(item)
        }.toList
      )
    override val removeEntries
        : Option[List[zio.aws.ec2.model.RemovePrefixListEntry.ReadOnly]] = scala
      .Option(impl.removeEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.RemovePrefixListEntry.wrap(item)
        }.toList
      )
    override val maxEntries: Option[Integer] = scala
      .Option(impl.maxEntries())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest
  ): zio.aws.ec2.model.ModifyManagedPrefixListRequest.ReadOnly = new Wrapper(
    impl
  )
}
