package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyLaunchTemplateResponse(
    launchTemplate: Option[zio.aws.ec2.model.LaunchTemplate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateResponse = {
    import ModifyLaunchTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateResponse
      .builder()
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyLaunchTemplateResponse.ReadOnly =
    zio.aws.ec2.model.ModifyLaunchTemplateResponse.wrap(buildAwsValue())
}
object ModifyLaunchTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyLaunchTemplateResponse =
      zio.aws.ec2.model.ModifyLaunchTemplateResponse(
        launchTemplate.map(value => value.asEditable)
      )
    def launchTemplate: Option[zio.aws.ec2.model.LaunchTemplate.ReadOnly]
    def getLaunchTemplate
        : ZIO[Any, AwsError, zio.aws.ec2.model.LaunchTemplate.ReadOnly] =
      AwsError.unwrapOptionField("launchTemplate", launchTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateResponse
  ) extends zio.aws.ec2.model.ModifyLaunchTemplateResponse.ReadOnly {
    override val launchTemplate
        : Option[zio.aws.ec2.model.LaunchTemplate.ReadOnly] = scala
      .Option(impl.launchTemplate())
      .map(value => zio.aws.ec2.model.LaunchTemplate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateResponse
  ): zio.aws.ec2.model.ModifyLaunchTemplateResponse.ReadOnly = new Wrapper(impl)
}
