package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  ResourceArn,
  LocalGatewayRouteTableVpcAssociationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LocalGatewayRouteTableVpcAssociation(
    localGatewayRouteTableVpcAssociationId: Option[
      LocalGatewayRouteTableVpcAssociationId
    ] = None,
    localGatewayRouteTableId: Option[String] = None,
    localGatewayRouteTableArn: Option[ResourceArn] = None,
    localGatewayId: Option[String] = None,
    vpcId: Option[String] = None,
    ownerId: Option[String] = None,
    state: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVpcAssociation = {
    import LocalGatewayRouteTableVpcAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVpcAssociation
      .builder()
      .optionallyWith(
        localGatewayRouteTableVpcAssociationId.map(value =>
          LocalGatewayRouteTableVpcAssociationId.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableVpcAssociationId)
      .optionallyWith(
        localGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.localGatewayRouteTableId)
      .optionallyWith(
        localGatewayRouteTableArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableArn)
      .optionallyWith(localGatewayId.map(value => value: java.lang.String))(
        _.localGatewayId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly =
    zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.wrap(buildAwsValue())
}
object LocalGatewayRouteTableVpcAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVpcAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation =
      zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation(
        localGatewayRouteTableVpcAssociationId.map(value => value),
        localGatewayRouteTableId.map(value => value),
        localGatewayRouteTableArn.map(value => value),
        localGatewayId.map(value => value),
        vpcId.map(value => value),
        ownerId.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def localGatewayRouteTableVpcAssociationId
        : Option[LocalGatewayRouteTableVpcAssociationId]
    def localGatewayRouteTableId: Option[String]
    def localGatewayRouteTableArn: Option[ResourceArn]
    def localGatewayId: Option[String]
    def vpcId: Option[String]
    def ownerId: Option[String]
    def state: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getLocalGatewayRouteTableVpcAssociationId
        : ZIO[Any, AwsError, LocalGatewayRouteTableVpcAssociationId] =
      AwsError.unwrapOptionField(
        "localGatewayRouteTableVpcAssociationId",
        localGatewayRouteTableVpcAssociationId
      )
    def getLocalGatewayRouteTableId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("localGatewayRouteTableId", localGatewayRouteTableId)
    def getLocalGatewayRouteTableArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("localGatewayRouteTableArn", localGatewayRouteTableArn)
    def getLocalGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVpcAssociation
  ) extends zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly {
    override val localGatewayRouteTableVpcAssociationId
        : Option[LocalGatewayRouteTableVpcAssociationId] = scala
      .Option(impl.localGatewayRouteTableVpcAssociationId())
      .map(value =>
        zio.aws.ec2.model.primitives
          .LocalGatewayRouteTableVpcAssociationId(value)
      )
    override val localGatewayRouteTableId: Option[String] =
      scala.Option(impl.localGatewayRouteTableId()).map(value => value: String)
    override val localGatewayRouteTableArn: Option[ResourceArn] = scala
      .Option(impl.localGatewayRouteTableArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val localGatewayId: Option[String] =
      scala.Option(impl.localGatewayId()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val state: Option[String] =
      scala.Option(impl.state()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVpcAssociation
  ): zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly =
    new Wrapper(impl)
}
