package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceMetadataOptionsState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState
}
object InstanceMetadataOptionsState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState
  ): zio.aws.ec2.model.InstanceMetadataOptionsState = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState.APPLIED =>
      val r = applied
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceMetadataOptionsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.InstanceMetadataOptionsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState.PENDING
  }
  case object applied extends zio.aws.ec2.model.InstanceMetadataOptionsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsState.APPLIED
  }
}
