package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  SecurityGroupName,
  SecurityGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportInstanceLaunchSpecification(
    additionalInfo: Option[String] = None,
    architecture: Option[zio.aws.ec2.model.ArchitectureValues] = None,
    groupIds: Option[Iterable[SecurityGroupId]] = None,
    groupNames: Option[Iterable[SecurityGroupName]] = None,
    instanceInitiatedShutdownBehavior: Option[
      zio.aws.ec2.model.ShutdownBehavior
    ] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    monitoring: Option[Boolean] = None,
    placement: Option[zio.aws.ec2.model.Placement] = None,
    privateIpAddress: Option[String] = None,
    subnetId: Option[SubnetId] = None,
    userData: Option[zio.aws.ec2.model.UserData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification = {
    import ImportInstanceLaunchSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification
      .builder()
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(
        groupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupIds)
      .optionallyWith(
        groupNames.map(value =>
          value.map { item =>
            SecurityGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groupNames)
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.unwrap)
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(monitoring.map(value => value: java.lang.Boolean))(
        _.monitoring
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(userData.map(value => value.buildAwsValue()))(_.userData)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportInstanceLaunchSpecification.ReadOnly =
    zio.aws.ec2.model.ImportInstanceLaunchSpecification.wrap(buildAwsValue())
}
object ImportInstanceLaunchSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportInstanceLaunchSpecification =
      zio.aws.ec2.model.ImportInstanceLaunchSpecification(
        additionalInfo.map(value => value),
        architecture.map(value => value),
        groupIds.map(value => value),
        groupNames.map(value => value),
        instanceInitiatedShutdownBehavior.map(value => value),
        instanceType.map(value => value),
        monitoring.map(value => value),
        placement.map(value => value.asEditable),
        privateIpAddress.map(value => value),
        subnetId.map(value => value),
        userData.map(value => value.asEditable)
      )
    def additionalInfo: Option[String]
    def architecture: Option[zio.aws.ec2.model.ArchitectureValues]
    def groupIds: Option[List[SecurityGroupId]]
    def groupNames: Option[List[SecurityGroupName]]
    def instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.ShutdownBehavior]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def monitoring: Option[Boolean]
    def placement: Option[zio.aws.ec2.model.Placement.ReadOnly]
    def privateIpAddress: Option[String]
    def subnetId: Option[SubnetId]
    def userData: Option[zio.aws.ec2.model.UserData.ReadOnly]
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.ec2.model.ArchitectureValues] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groupIds", groupIds)
    def getGroupNames: ZIO[Any, AwsError, List[SecurityGroupName]] =
      AwsError.unwrapOptionField("groupNames", groupNames)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.ShutdownBehavior] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getMonitoring: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("monitoring", monitoring)
    def getPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.Placement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUserData: ZIO[Any, AwsError, zio.aws.ec2.model.UserData.ReadOnly] =
      AwsError.unwrapOptionField("userData", userData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification
  ) extends zio.aws.ec2.model.ImportInstanceLaunchSpecification.ReadOnly {
    override val additionalInfo: Option[String] =
      scala.Option(impl.additionalInfo()).map(value => value: String)
    override val architecture: Option[zio.aws.ec2.model.ArchitectureValues] =
      scala
        .Option(impl.architecture())
        .map(value => zio.aws.ec2.model.ArchitectureValues.wrap(value))
    override val groupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.groupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val groupNames: Option[List[SecurityGroupName]] = scala
      .Option(impl.groupNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupName(item)
        }.toList
      )
    override val instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.ShutdownBehavior] = scala
      .Option(impl.instanceInitiatedShutdownBehavior())
      .map(value => zio.aws.ec2.model.ShutdownBehavior.wrap(value))
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val monitoring: Option[Boolean] =
      scala.Option(impl.monitoring()).map(value => value: Boolean)
    override val placement: Option[zio.aws.ec2.model.Placement.ReadOnly] = scala
      .Option(impl.placement())
      .map(value => zio.aws.ec2.model.Placement.wrap(value))
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val userData: Option[zio.aws.ec2.model.UserData.ReadOnly] = scala
      .Option(impl.userData())
      .map(value => zio.aws.ec2.model.UserData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification
  ): zio.aws.ec2.model.ImportInstanceLaunchSpecification.ReadOnly = new Wrapper(
    impl
  )
}
