package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ImageTypeValues {
  def unwrap: software.amazon.awssdk.services.ec2.model.ImageTypeValues
}
object ImageTypeValues {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ImageTypeValues
  ): zio.aws.ec2.model.ImageTypeValues = value match {
    case software.amazon.awssdk.services.ec2.model.ImageTypeValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ImageTypeValues.MACHINE =>
      val r = machine
      r
    case software.amazon.awssdk.services.ec2.model.ImageTypeValues.KERNEL =>
      val r = kernel
      r
    case software.amazon.awssdk.services.ec2.model.ImageTypeValues.RAMDISK =>
      val r = ramdisk
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ImageTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageTypeValues =
      software.amazon.awssdk.services.ec2.model.ImageTypeValues.UNKNOWN_TO_SDK_VERSION
  }
  case object machine extends zio.aws.ec2.model.ImageTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageTypeValues =
      software.amazon.awssdk.services.ec2.model.ImageTypeValues.MACHINE
  }
  case object kernel extends zio.aws.ec2.model.ImageTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageTypeValues =
      software.amazon.awssdk.services.ec2.model.ImageTypeValues.KERNEL
  }
  case object ramdisk extends zio.aws.ec2.model.ImageTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImageTypeValues =
      software.amazon.awssdk.services.ec2.model.ImageTypeValues.RAMDISK
  }
}
