package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetIpamPoolAllocationsResponse(
    ipamPoolAllocations: Option[
      Iterable[zio.aws.ec2.model.IpamPoolAllocation]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse = {
    import GetIpamPoolAllocationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse
      .builder()
      .optionallyWith(
        ipamPoolAllocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipamPoolAllocations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamPoolAllocationsResponse.ReadOnly =
    zio.aws.ec2.model.GetIpamPoolAllocationsResponse.wrap(buildAwsValue())
}
object GetIpamPoolAllocationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamPoolAllocationsResponse =
      zio.aws.ec2.model.GetIpamPoolAllocationsResponse(
        ipamPoolAllocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ipamPoolAllocations
        : Option[List[zio.aws.ec2.model.IpamPoolAllocation.ReadOnly]]
    def nextToken: Option[NextToken]
    def getIpamPoolAllocations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IpamPoolAllocation.ReadOnly
    ]] = AwsError.unwrapOptionField("ipamPoolAllocations", ipamPoolAllocations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse
  ) extends zio.aws.ec2.model.GetIpamPoolAllocationsResponse.ReadOnly {
    override val ipamPoolAllocations
        : Option[List[zio.aws.ec2.model.IpamPoolAllocation.ReadOnly]] = scala
      .Option(impl.ipamPoolAllocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpamPoolAllocation.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamPoolAllocationsResponse
  ): zio.aws.ec2.model.GetIpamPoolAllocationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
