package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportClientVpnClientConfigurationResponse(
    clientConfiguration: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationResponse = {
    import ExportClientVpnClientConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationResponse
      .builder()
      .optionallyWith(
        clientConfiguration.map(value => value: java.lang.String)
      )(_.clientConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse.ReadOnly =
    zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse
      .wrap(buildAwsValue())
}
object ExportClientVpnClientConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse =
      zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse(
        clientConfiguration.map(value => value)
      )
    def clientConfiguration: Option[String]
    def getClientConfiguration: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientConfiguration", clientConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationResponse
  ) extends zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse.ReadOnly {
    override val clientConfiguration: Option[String] =
      scala.Option(impl.clientConfiguration()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportClientVpnClientConfigurationResponse
  ): zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
