package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisableFastSnapshotRestoreStateErrorItem(
    availabilityZone: Option[String] = None,
    error: Option[zio.aws.ec2.model.DisableFastSnapshotRestoreStateError] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreStateErrorItem = {
    import DisableFastSnapshotRestoreStateErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreStateErrorItem
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.ReadOnly =
    zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem
      .wrap(buildAwsValue())
}
object DisableFastSnapshotRestoreStateErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreStateErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem =
      zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem(
        availabilityZone.map(value => value),
        error.map(value => value.asEditable)
      )
    def availabilityZone: Option[String]
    def error: Option[
      zio.aws.ec2.model.DisableFastSnapshotRestoreStateError.ReadOnly
    ]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DisableFastSnapshotRestoreStateError.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreStateErrorItem
  ) extends zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val error: Option[
      zio.aws.ec2.model.DisableFastSnapshotRestoreStateError.ReadOnly
    ] = scala
      .Option(impl.error())
      .map(value =>
        zio.aws.ec2.model.DisableFastSnapshotRestoreStateError.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreStateErrorItem
  ): zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem.ReadOnly =
    new Wrapper(impl)
}
