package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVolumeAttributeResponse(
    autoEnableIO: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    productCodes: Option[Iterable[zio.aws.ec2.model.ProductCode]] = None,
    volumeId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse = {
    import DescribeVolumeAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse
      .builder()
      .optionallyWith(autoEnableIO.map(value => value.buildAwsValue()))(
        _.autoEnableIO
      )
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVolumeAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVolumeAttributeResponse.wrap(buildAwsValue())
}
object DescribeVolumeAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumeAttributeResponse =
      zio.aws.ec2.model.DescribeVolumeAttributeResponse(
        autoEnableIO.map(value => value.asEditable),
        productCodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumeId.map(value => value)
      )
    def autoEnableIO: Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def productCodes: Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def volumeId: Option[String]
    def getAutoEnableIO
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("autoEnableIO", autoEnableIO)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse
  ) extends zio.aws.ec2.model.DescribeVolumeAttributeResponse.ReadOnly {
    override val autoEnableIO
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.autoEnableIO())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val productCodes
        : Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]] = scala
      .Option(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ProductCode.wrap(item)
        }.toList
      )
    override val volumeId: Option[String] =
      scala.Option(impl.volumeId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeResponse
  ): zio.aws.ec2.model.DescribeVolumeAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
