package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  TransitGatewayMaxResults,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayMulticastDomainsRequest(
    transitGatewayMulticastDomainIds: Option[
      Iterable[TransitGatewayMulticastDomainId]
    ] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[TransitGatewayMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest = {
    import DescribeTransitGatewayMulticastDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainIds.map(value =>
          value.map { item =>
            TransitGatewayMulticastDomainId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.transitGatewayMulticastDomainIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => TransitGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayMulticastDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest =
      zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest(
        transitGatewayMulticastDomainIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def transitGatewayMulticastDomainIds
        : Option[List[TransitGatewayMulticastDomainId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[TransitGatewayMaxResults]
    def nextToken: Option[String]
    def getTransitGatewayMulticastDomainIds
        : ZIO[Any, AwsError, List[TransitGatewayMulticastDomainId]] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainIds",
        transitGatewayMulticastDomainIds
      )
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, TransitGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
  ) extends zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest.ReadOnly {
    override val transitGatewayMulticastDomainIds
        : Option[List[TransitGatewayMulticastDomainId]] = scala
      .Option(impl.transitGatewayMulticastDomainIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[TransitGatewayMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
  ): zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest.ReadOnly =
    new Wrapper(impl)
}
