package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotTierStatusResponse(
    snapshotTierStatuses: Option[
      Iterable[zio.aws.ec2.model.SnapshotTierStatus]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse = {
    import DescribeSnapshotTierStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse
      .builder()
      .optionallyWith(
        snapshotTierStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshotTierStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSnapshotTierStatusResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSnapshotTierStatusResponse.wrap(buildAwsValue())
}
object DescribeSnapshotTierStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSnapshotTierStatusResponse =
      zio.aws.ec2.model.DescribeSnapshotTierStatusResponse(
        snapshotTierStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def snapshotTierStatuses
        : Option[List[zio.aws.ec2.model.SnapshotTierStatus.ReadOnly]]
    def nextToken: Option[String]
    def getSnapshotTierStatuses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SnapshotTierStatus.ReadOnly
    ]] =
      AwsError.unwrapOptionField("snapshotTierStatuses", snapshotTierStatuses)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse
  ) extends zio.aws.ec2.model.DescribeSnapshotTierStatusResponse.ReadOnly {
    override val snapshotTierStatuses
        : Option[List[zio.aws.ec2.model.SnapshotTierStatus.ReadOnly]] = scala
      .Option(impl.snapshotTierStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SnapshotTierStatus.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotTierStatusResponse
  ): zio.aws.ec2.model.DescribeSnapshotTierStatusResponse.ReadOnly =
    new Wrapper(impl)
}
