package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotAttributeRequest(
    attribute: zio.aws.ec2.model.SnapshotAttributeName,
    snapshotId: SnapshotId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest = {
    import DescribeSnapshotAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSnapshotAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSnapshotAttributeRequest.wrap(buildAwsValue())
}
object DescribeSnapshotAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSnapshotAttributeRequest =
      zio.aws.ec2.model.DescribeSnapshotAttributeRequest(attribute, snapshotId)
    def attribute: zio.aws.ec2.model.SnapshotAttributeName
    def snapshotId: SnapshotId
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.ec2.model.SnapshotAttributeName] =
      ZIO.succeed(attribute)
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest
  ) extends zio.aws.ec2.model.DescribeSnapshotAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.SnapshotAttributeName =
      zio.aws.ec2.model.SnapshotAttributeName.wrap(impl.attribute())
    override val snapshotId: SnapshotId =
      zio.aws.ec2.model.primitives.SnapshotId(impl.snapshotId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotAttributeRequest
  ): zio.aws.ec2.model.DescribeSnapshotAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
