package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstancesModificationsResponse(
    nextToken: Option[String] = None,
    reservedInstancesModifications: Option[
      Iterable[zio.aws.ec2.model.ReservedInstancesModification]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse = {
    import DescribeReservedInstancesModificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        reservedInstancesModifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedInstancesModifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedInstancesModificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse =
      zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse(
        nextToken.map(value => value),
        reservedInstancesModifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def reservedInstancesModifications
        : Option[List[zio.aws.ec2.model.ReservedInstancesModification.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReservedInstancesModifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReservedInstancesModification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedInstancesModifications",
      reservedInstancesModifications
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse
  ) extends zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val reservedInstancesModifications: Option[
      List[zio.aws.ec2.model.ReservedInstancesModification.ReadOnly]
    ] = scala
      .Option(impl.reservedInstancesModifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ReservedInstancesModification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse
  ): zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse.ReadOnly =
    new Wrapper(impl)
}
