package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLaunchTemplateVersionsResponse(
    launchTemplateVersions: Option[
      Iterable[zio.aws.ec2.model.LaunchTemplateVersion]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse = {
    import DescribeLaunchTemplateVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse
      .builder()
      .optionallyWith(
        launchTemplateVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplateVersions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse
      .wrap(buildAwsValue())
}
object DescribeLaunchTemplateVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse =
      zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse(
        launchTemplateVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def launchTemplateVersions
        : Option[List[zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly]]
    def nextToken: Option[String]
    def getLaunchTemplateVersions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "launchTemplateVersions",
      launchTemplateVersions
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse
  ) extends zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse.ReadOnly {
    override val launchTemplateVersions
        : Option[List[zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly]] = scala
      .Option(impl.launchTemplateVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateVersion.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsResponse
  ): zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
