package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ImportImageTaskId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImportImageTasksRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    importTaskIds: Option[Iterable[ImportImageTaskId]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest = {
    import DescribeImportImageTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        importTaskIds.map(value =>
          value.map { item =>
            ImportImageTaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.importTaskIds)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImportImageTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeImportImageTasksRequest.wrap(buildAwsValue())
}
object DescribeImportImageTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImportImageTasksRequest =
      zio.aws.ec2.model.DescribeImportImageTasksRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        importTaskIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def importTaskIds: Option[List[ImportImageTaskId]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getImportTaskIds: ZIO[Any, AwsError, List[ImportImageTaskId]] =
      AwsError.unwrapOptionField("importTaskIds", importTaskIds)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest
  ) extends zio.aws.ec2.model.DescribeImportImageTasksRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val importTaskIds: Option[List[ImportImageTaskId]] = scala
      .Option(impl.importTaskIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ImportImageTaskId(item)
        }.toList
      )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest
  ): zio.aws.ec2.model.DescribeImportImageTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
