package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCustomerGatewaysResponse(
    customerGateways: Option[Iterable[zio.aws.ec2.model.CustomerGateway]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse = {
    import DescribeCustomerGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse
      .builder()
      .optionallyWith(
        customerGateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customerGateways)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeCustomerGatewaysResponse.ReadOnly =
    zio.aws.ec2.model.DescribeCustomerGatewaysResponse.wrap(buildAwsValue())
}
object DescribeCustomerGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCustomerGatewaysResponse =
      zio.aws.ec2.model.DescribeCustomerGatewaysResponse(
        customerGateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customerGateways
        : Option[List[zio.aws.ec2.model.CustomerGateway.ReadOnly]]
    def getCustomerGateways
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.CustomerGateway.ReadOnly]] =
      AwsError.unwrapOptionField("customerGateways", customerGateways)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse
  ) extends zio.aws.ec2.model.DescribeCustomerGatewaysResponse.ReadOnly {
    override val customerGateways
        : Option[List[zio.aws.ec2.model.CustomerGateway.ReadOnly]] = scala
      .Option(impl.customerGateways())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.CustomerGateway.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse
  ): zio.aws.ec2.model.DescribeCustomerGatewaysResponse.ReadOnly = new Wrapper(
    impl
  )
}
