package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsPathId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInsightsPathResponse(
    networkInsightsPathId: Option[NetworkInsightsPathId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathResponse = {
    import DeleteNetworkInsightsPathResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathResponse
      .builder()
      .optionallyWith(
        networkInsightsPathId.map(value =>
          NetworkInsightsPathId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsPathId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteNetworkInsightsPathResponse.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInsightsPathResponse.wrap(buildAwsValue())
}
object DeleteNetworkInsightsPathResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkInsightsPathResponse =
      zio.aws.ec2.model.DeleteNetworkInsightsPathResponse(
        networkInsightsPathId.map(value => value)
      )
    def networkInsightsPathId: Option[NetworkInsightsPathId]
    def getNetworkInsightsPathId: ZIO[Any, AwsError, NetworkInsightsPathId] =
      AwsError.unwrapOptionField("networkInsightsPathId", networkInsightsPathId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathResponse
  ) extends zio.aws.ec2.model.DeleteNetworkInsightsPathResponse.ReadOnly {
    override val networkInsightsPathId: Option[NetworkInsightsPathId] = scala
      .Option(impl.networkInsightsPathId())
      .map(value => zio.aws.ec2.model.primitives.NetworkInsightsPathId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsPathResponse
  ): zio.aws.ec2.model.DeleteNetworkInsightsPathResponse.ReadOnly = new Wrapper(
    impl
  )
}
