package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLaunchTemplateVersionResponse(
    launchTemplateVersion: Option[zio.aws.ec2.model.LaunchTemplateVersion] =
      None,
    warning: Option[zio.aws.ec2.model.ValidationWarning] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse = {
    import CreateLaunchTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse
      .builder()
      .optionallyWith(
        launchTemplateVersion.map(value => value.buildAwsValue())
      )(_.launchTemplateVersion)
      .optionallyWith(warning.map(value => value.buildAwsValue()))(_.warning)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateLaunchTemplateVersionResponse.ReadOnly =
    zio.aws.ec2.model.CreateLaunchTemplateVersionResponse.wrap(buildAwsValue())
}
object CreateLaunchTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateLaunchTemplateVersionResponse =
      zio.aws.ec2.model.CreateLaunchTemplateVersionResponse(
        launchTemplateVersion.map(value => value.asEditable),
        warning.map(value => value.asEditable)
      )
    def launchTemplateVersion
        : Option[zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly]
    def warning: Option[zio.aws.ec2.model.ValidationWarning.ReadOnly]
    def getLaunchTemplateVersion
        : ZIO[Any, AwsError, zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly] =
      AwsError.unwrapOptionField("launchTemplateVersion", launchTemplateVersion)
    def getWarning
        : ZIO[Any, AwsError, zio.aws.ec2.model.ValidationWarning.ReadOnly] =
      AwsError.unwrapOptionField("warning", warning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse
  ) extends zio.aws.ec2.model.CreateLaunchTemplateVersionResponse.ReadOnly {
    override val launchTemplateVersion
        : Option[zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly] = scala
      .Option(impl.launchTemplateVersion())
      .map(value => zio.aws.ec2.model.LaunchTemplateVersion.wrap(value))
    override val warning: Option[zio.aws.ec2.model.ValidationWarning.ReadOnly] =
      scala
        .Option(impl.warning())
        .map(value => zio.aws.ec2.model.ValidationWarning.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionResponse
  ): zio.aws.ec2.model.CreateLaunchTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
