package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  Integer,
  CapacityReservationFleetId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateCapacityReservationFleetResponse(
    capacityReservationFleetId: Option[CapacityReservationFleetId] = None,
    state: Option[zio.aws.ec2.model.CapacityReservationFleetState] = None,
    totalTargetCapacity: Option[Integer] = None,
    totalFulfilledCapacity: Option[Double] = None,
    instanceMatchCriteria: Option[
      zio.aws.ec2.model.FleetInstanceMatchCriteria
    ] = None,
    allocationStrategy: Option[String] = None,
    createTime: Option[MillisecondDateTime] = None,
    endDate: Option[MillisecondDateTime] = None,
    tenancy: Option[zio.aws.ec2.model.FleetCapacityReservationTenancy] = None,
    fleetCapacityReservations: Option[
      Iterable[zio.aws.ec2.model.FleetCapacityReservation]
    ] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse = {
    import CreateCapacityReservationFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse
      .builder()
      .optionallyWith(
        capacityReservationFleetId.map(value =>
          CapacityReservationFleetId.unwrap(value): java.lang.String
        )
      )(_.capacityReservationFleetId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        totalTargetCapacity.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.totalTargetCapacity)
      .optionallyWith(
        totalFulfilledCapacity.map(value => value: java.lang.Double)
      )(_.totalFulfilledCapacity)
      .optionallyWith(instanceMatchCriteria.map(value => value.unwrap))(
        _.instanceMatchCriteria
      )
      .optionallyWith(allocationStrategy.map(value => value: java.lang.String))(
        _.allocationStrategy
      )
      .optionallyWith(
        createTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(
        fleetCapacityReservations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetCapacityReservations)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly =
    zio.aws.ec2.model.CreateCapacityReservationFleetResponse
      .wrap(buildAwsValue())
}
object CreateCapacityReservationFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCapacityReservationFleetResponse =
      zio.aws.ec2.model.CreateCapacityReservationFleetResponse(
        capacityReservationFleetId.map(value => value),
        state.map(value => value),
        totalTargetCapacity.map(value => value),
        totalFulfilledCapacity.map(value => value),
        instanceMatchCriteria.map(value => value),
        allocationStrategy.map(value => value),
        createTime.map(value => value),
        endDate.map(value => value),
        tenancy.map(value => value),
        fleetCapacityReservations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def capacityReservationFleetId: Option[CapacityReservationFleetId]
    def state: Option[zio.aws.ec2.model.CapacityReservationFleetState]
    def totalTargetCapacity: Option[Integer]
    def totalFulfilledCapacity: Option[Double]
    def instanceMatchCriteria
        : Option[zio.aws.ec2.model.FleetInstanceMatchCriteria]
    def allocationStrategy: Option[String]
    def createTime: Option[MillisecondDateTime]
    def endDate: Option[MillisecondDateTime]
    def tenancy: Option[zio.aws.ec2.model.FleetCapacityReservationTenancy]
    def fleetCapacityReservations
        : Option[List[zio.aws.ec2.model.FleetCapacityReservation.ReadOnly]]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getCapacityReservationFleetId
        : ZIO[Any, AwsError, CapacityReservationFleetId] =
      AwsError.unwrapOptionField(
        "capacityReservationFleetId",
        capacityReservationFleetId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationFleetState] =
      AwsError.unwrapOptionField("state", state)
    def getTotalTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalTargetCapacity", totalTargetCapacity)
    def getTotalFulfilledCapacity: ZIO[Any, AwsError, Double] = AwsError
      .unwrapOptionField("totalFulfilledCapacity", totalFulfilledCapacity)
    def getInstanceMatchCriteria
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetInstanceMatchCriteria] =
      AwsError.unwrapOptionField("instanceMatchCriteria", instanceMatchCriteria)
    def getAllocationStrategy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getCreateTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getTenancy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetCapacityReservationTenancy
    ] = AwsError.unwrapOptionField("tenancy", tenancy)
    def getFleetCapacityReservations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FleetCapacityReservation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fleetCapacityReservations",
      fleetCapacityReservations
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse
  ) extends zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly {
    override val capacityReservationFleetId
        : Option[CapacityReservationFleetId] = scala
      .Option(impl.capacityReservationFleetId())
      .map(value =>
        zio.aws.ec2.model.primitives.CapacityReservationFleetId(value)
      )
    override val state
        : Option[zio.aws.ec2.model.CapacityReservationFleetState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.CapacityReservationFleetState.wrap(value))
    override val totalTargetCapacity: Option[Integer] = scala
      .Option(impl.totalTargetCapacity())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val totalFulfilledCapacity: Option[Double] =
      scala.Option(impl.totalFulfilledCapacity()).map(value => value: Double)
    override val instanceMatchCriteria
        : Option[zio.aws.ec2.model.FleetInstanceMatchCriteria] = scala
      .Option(impl.instanceMatchCriteria())
      .map(value => zio.aws.ec2.model.FleetInstanceMatchCriteria.wrap(value))
    override val allocationStrategy: Option[String] =
      scala.Option(impl.allocationStrategy()).map(value => value: String)
    override val createTime: Option[MillisecondDateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endDate: Option[MillisecondDateTime] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val tenancy
        : Option[zio.aws.ec2.model.FleetCapacityReservationTenancy] = scala
      .Option(impl.tenancy())
      .map(value =>
        zio.aws.ec2.model.FleetCapacityReservationTenancy.wrap(value)
      )
    override val fleetCapacityReservations
        : Option[List[zio.aws.ec2.model.FleetCapacityReservation.ReadOnly]] =
      scala
        .Option(impl.fleetCapacityReservations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.FleetCapacityReservation.wrap(item)
          }.toList
        )
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse
  ): zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly =
    new Wrapper(impl)
}
