package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait BgpStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.BgpStatus
}
object BgpStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.BgpStatus
  ): zio.aws.ec2.model.BgpStatus = value match {
    case software.amazon.awssdk.services.ec2.model.BgpStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.BgpStatus.UP =>
      val r = up
      r
    case software.amazon.awssdk.services.ec2.model.BgpStatus.DOWN =>
      val r = down
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.BgpStatus {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BgpStatus =
      software.amazon.awssdk.services.ec2.model.BgpStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object up extends zio.aws.ec2.model.BgpStatus {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BgpStatus =
      software.amazon.awssdk.services.ec2.model.BgpStatus.UP
  }
  case object down extends zio.aws.ec2.model.BgpStatus {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BgpStatus =
      software.amazon.awssdk.services.ec2.model.BgpStatus.DOWN
  }
}
