package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociationStatus(
    code: Option[zio.aws.ec2.model.AssociationStatusCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociationStatus = {
    import AssociationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociationStatus
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociationStatus.ReadOnly =
    zio.aws.ec2.model.AssociationStatus.wrap(buildAwsValue())
}
object AssociationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociationStatus = zio.aws.ec2.model
      .AssociationStatus(code.map(value => value), message.map(value => value))
    def code: Option[zio.aws.ec2.model.AssociationStatusCode]
    def message: Option[String]
    def getCode: ZIO[Any, AwsError, zio.aws.ec2.model.AssociationStatusCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociationStatus
  ) extends zio.aws.ec2.model.AssociationStatus.ReadOnly {
    override val code: Option[zio.aws.ec2.model.AssociationStatusCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.ec2.model.AssociationStatusCode.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociationStatus
  ): zio.aws.ec2.model.AssociationStatus.ReadOnly = new Wrapper(impl)
}
