package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait UnlimitedSupportedInstanceFamily {
  def unwrap: software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily
}
object UnlimitedSupportedInstanceFamily {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily
  ): zio.aws.ec2.model.UnlimitedSupportedInstanceFamily = value match {
    case software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily.T2 =>
      val r = t2
      r
    case software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily.T3 =>
      val r = t3
      r
    case software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily.T3_A =>
      val r = t3a
      r
    case software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily.T4_G =>
      val r = t4g
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.UnlimitedSupportedInstanceFamily {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily =
      software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily.UNKNOWN_TO_SDK_VERSION
  }
  case object t2 extends zio.aws.ec2.model.UnlimitedSupportedInstanceFamily {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily =
      software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily.T2
  }
  case object t3 extends zio.aws.ec2.model.UnlimitedSupportedInstanceFamily {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily =
      software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily.T3
  }
  case object t3a extends zio.aws.ec2.model.UnlimitedSupportedInstanceFamily {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily =
      software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily.T3_A
  }
  case object t4g extends zio.aws.ec2.model.UnlimitedSupportedInstanceFamily {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily =
      software.amazon.awssdk.services.ec2.model.UnlimitedSupportedInstanceFamily.T4_G
  }
}
