package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TransitGatewayAttachment(
    transitGatewayAttachmentId: Option[String] = None,
    transitGatewayId: Option[String] = None,
    transitGatewayOwnerId: Option[String] = None,
    resourceOwnerId: Option[String] = None,
    resourceType: Option[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = None,
    resourceId: Option[String] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayAttachmentState] = None,
    association: Option[zio.aws.ec2.model.TransitGatewayAttachmentAssociation] =
      None,
    creationTime: Option[DateTime] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment = {
    import TransitGatewayAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(
        transitGatewayOwnerId.map(value => value: java.lang.String)
      )(_.transitGatewayOwnerId)
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly =
    zio.aws.ec2.model.TransitGatewayAttachment.wrap(buildAwsValue())
}
object TransitGatewayAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayAttachment =
      zio.aws.ec2.model.TransitGatewayAttachment(
        transitGatewayAttachmentId.map(value => value),
        transitGatewayId.map(value => value),
        transitGatewayOwnerId.map(value => value),
        resourceOwnerId.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        state.map(value => value),
        association.map(value => value.asEditable),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: Option[String]
    def transitGatewayId: Option[String]
    def transitGatewayOwnerId: Option[String]
    def resourceOwnerId: Option[String]
    def resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def resourceId: Option[String]
    def state: Option[zio.aws.ec2.model.TransitGatewayAttachmentState]
    def association
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly]
    def creationTime: Option[DateTime]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getTransitGatewayOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayOwnerId", transitGatewayOwnerId)
    def getResourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment
  ) extends zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly {
    override val transitGatewayAttachmentId: Option[String] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value => value: String)
    override val transitGatewayId: Option[String] =
      scala.Option(impl.transitGatewayId()).map(value => value: String)
    override val transitGatewayOwnerId: Option[String] =
      scala.Option(impl.transitGatewayOwnerId()).map(value => value: String)
    override val resourceOwnerId: Option[String] =
      scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override val resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
      )
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.TransitGatewayAttachmentState.wrap(value))
    override val association: Option[
      zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly
    ] = scala
      .Option(impl.association())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAttachmentAssociation.wrap(value)
      )
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment
  ): zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly = new Wrapper(impl)
}
