package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopInstancesResponse(
    stoppingInstances: Option[Iterable[zio.aws.ec2.model.InstanceStateChange]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StopInstancesResponse = {
    import StopInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StopInstancesResponse
      .builder()
      .optionallyWith(
        stoppingInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stoppingInstances)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StopInstancesResponse.ReadOnly =
    zio.aws.ec2.model.StopInstancesResponse.wrap(buildAwsValue())
}
object StopInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StopInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StopInstancesResponse =
      zio.aws.ec2.model.StopInstancesResponse(
        stoppingInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def stoppingInstances
        : Option[List[zio.aws.ec2.model.InstanceStateChange.ReadOnly]]
    def getStoppingInstances: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceStateChange.ReadOnly
    ]] = AwsError.unwrapOptionField("stoppingInstances", stoppingInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StopInstancesResponse
  ) extends zio.aws.ec2.model.StopInstancesResponse.ReadOnly {
    override val stoppingInstances
        : Option[List[zio.aws.ec2.model.InstanceStateChange.ReadOnly]] = scala
      .Option(impl.stoppingInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceStateChange.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StopInstancesResponse
  ): zio.aws.ec2.model.StopInstancesResponse.ReadOnly = new Wrapper(impl)
}
