package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReservedInstancesModification(
    clientToken: Option[String] = None,
    createDate: Option[DateTime] = None,
    effectiveDate: Option[DateTime] = None,
    modificationResults: Option[
      Iterable[zio.aws.ec2.model.ReservedInstancesModificationResult]
    ] = None,
    reservedInstancesIds: Option[
      Iterable[zio.aws.ec2.model.ReservedInstancesId]
    ] = None,
    reservedInstancesModificationId: Option[String] = None,
    status: Option[String] = None,
    statusMessage: Option[String] = None,
    updateDate: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstancesModification = {
    import ReservedInstancesModification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstancesModification
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(createDate.map(value => DateTime.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        effectiveDate.map(value => DateTime.unwrap(value): Instant)
      )(_.effectiveDate)
      .optionallyWith(
        modificationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modificationResults)
      .optionallyWith(
        reservedInstancesIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedInstancesIds)
      .optionallyWith(
        reservedInstancesModificationId.map(value => value: java.lang.String)
      )(_.reservedInstancesModificationId)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(updateDate.map(value => DateTime.unwrap(value): Instant))(
        _.updateDate
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstancesModification.ReadOnly =
    zio.aws.ec2.model.ReservedInstancesModification.wrap(buildAwsValue())
}
object ReservedInstancesModification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstancesModification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstancesModification =
      zio.aws.ec2.model.ReservedInstancesModification(
        clientToken.map(value => value),
        createDate.map(value => value),
        effectiveDate.map(value => value),
        modificationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedInstancesIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedInstancesModificationId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        updateDate.map(value => value)
      )
    def clientToken: Option[String]
    def createDate: Option[DateTime]
    def effectiveDate: Option[DateTime]
    def modificationResults: Option[
      List[zio.aws.ec2.model.ReservedInstancesModificationResult.ReadOnly]
    ]
    def reservedInstancesIds
        : Option[List[zio.aws.ec2.model.ReservedInstancesId.ReadOnly]]
    def reservedInstancesModificationId: Option[String]
    def status: Option[String]
    def statusMessage: Option[String]
    def updateDate: Option[DateTime]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCreateDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getEffectiveDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("effectiveDate", effectiveDate)
    def getModificationResults: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReservedInstancesModificationResult.ReadOnly
    ]] = AwsError.unwrapOptionField("modificationResults", modificationResults)
    def getReservedInstancesIds: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReservedInstancesId.ReadOnly
    ]] =
      AwsError.unwrapOptionField("reservedInstancesIds", reservedInstancesIds)
    def getReservedInstancesModificationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedInstancesModificationId",
        reservedInstancesModificationId
      )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getUpdateDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updateDate", updateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesModification
  ) extends zio.aws.ec2.model.ReservedInstancesModification.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val createDate: Option[DateTime] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val effectiveDate: Option[DateTime] = scala
      .Option(impl.effectiveDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val modificationResults: Option[
      List[zio.aws.ec2.model.ReservedInstancesModificationResult.ReadOnly]
    ] = scala
      .Option(impl.modificationResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ReservedInstancesModificationResult.wrap(item)
        }.toList
      )
    override val reservedInstancesIds
        : Option[List[zio.aws.ec2.model.ReservedInstancesId.ReadOnly]] = scala
      .Option(impl.reservedInstancesIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ReservedInstancesId.wrap(item)
        }.toList
      )
    override val reservedInstancesModificationId: Option[String] = scala
      .Option(impl.reservedInstancesModificationId())
      .map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val updateDate: Option[DateTime] = scala
      .Option(impl.updateDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstancesModification
  ): zio.aws.ec2.model.ReservedInstancesModification.ReadOnly = new Wrapper(
    impl
  )
}
