package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RequestSpotFleetResponse(
    spotFleetRequestId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse = {
    import RequestSpotFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse
      .builder()
      .optionallyWith(spotFleetRequestId.map(value => value: java.lang.String))(
        _.spotFleetRequestId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestSpotFleetResponse.ReadOnly =
    zio.aws.ec2.model.RequestSpotFleetResponse.wrap(buildAwsValue())
}
object RequestSpotFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestSpotFleetResponse =
      zio.aws.ec2.model
        .RequestSpotFleetResponse(spotFleetRequestId.map(value => value))
    def spotFleetRequestId: Option[String]
    def getSpotFleetRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotFleetRequestId", spotFleetRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse
  ) extends zio.aws.ec2.model.RequestSpotFleetResponse.ReadOnly {
    override val spotFleetRequestId: Option[String] =
      scala.Option(impl.spotFleetRequestId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotFleetResponse
  ): zio.aws.ec2.model.RequestSpotFleetResponse.ReadOnly = new Wrapper(impl)
}
