package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecurringCharge(
    amount: Option[Double] = None,
    frequency: Option[zio.aws.ec2.model.RecurringChargeFrequency] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RecurringCharge = {
    import RecurringCharge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RecurringCharge
      .builder()
      .optionallyWith(amount.map(value => value: java.lang.Double))(_.amount)
      .optionallyWith(frequency.map(value => value.unwrap))(_.frequency)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RecurringCharge.ReadOnly =
    zio.aws.ec2.model.RecurringCharge.wrap(buildAwsValue())
}
object RecurringCharge {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RecurringCharge
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RecurringCharge =
      zio.aws.ec2.model.RecurringCharge(
        amount.map(value => value),
        frequency.map(value => value)
      )
    def amount: Option[Double]
    def frequency: Option[zio.aws.ec2.model.RecurringChargeFrequency]
    def getAmount: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("amount", amount)
    def getFrequency
        : ZIO[Any, AwsError, zio.aws.ec2.model.RecurringChargeFrequency] =
      AwsError.unwrapOptionField("frequency", frequency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RecurringCharge
  ) extends zio.aws.ec2.model.RecurringCharge.ReadOnly {
    override val amount: Option[Double] =
      scala.Option(impl.amount()).map(value => value: Double)
    override val frequency: Option[zio.aws.ec2.model.RecurringChargeFrequency] =
      scala
        .Option(impl.frequency())
        .map(value => zio.aws.ec2.model.RecurringChargeFrequency.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RecurringCharge
  ): zio.aws.ec2.model.RecurringCharge.ReadOnly = new Wrapper(impl)
}
