package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PlacementStrategy {
  def unwrap: software.amazon.awssdk.services.ec2.model.PlacementStrategy
}
object PlacementStrategy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PlacementStrategy
  ): zio.aws.ec2.model.PlacementStrategy = value match {
    case software.amazon.awssdk.services.ec2.model.PlacementStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PlacementStrategy.CLUSTER =>
      val r = cluster
      r
    case software.amazon.awssdk.services.ec2.model.PlacementStrategy.SPREAD =>
      val r = spread
      r
    case software.amazon.awssdk.services.ec2.model.PlacementStrategy.PARTITION =>
      val r = partition
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.PlacementStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementStrategy =
      software.amazon.awssdk.services.ec2.model.PlacementStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object cluster extends zio.aws.ec2.model.PlacementStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementStrategy =
      software.amazon.awssdk.services.ec2.model.PlacementStrategy.CLUSTER
  }
  case object spread extends zio.aws.ec2.model.PlacementStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementStrategy =
      software.amazon.awssdk.services.ec2.model.PlacementStrategy.SPREAD
  }
  case object partition extends zio.aws.ec2.model.PlacementStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PlacementStrategy =
      software.amazon.awssdk.services.ec2.model.PlacementStrategy.PARTITION
  }
}
