package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyTransitGatewayResponse(
    transitGateway: Option[zio.aws.ec2.model.TransitGateway] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayResponse = {
    import ModifyTransitGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayResponse
      .builder()
      .optionallyWith(transitGateway.map(value => value.buildAwsValue()))(
        _.transitGateway
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyTransitGatewayResponse.ReadOnly =
    zio.aws.ec2.model.ModifyTransitGatewayResponse.wrap(buildAwsValue())
}
object ModifyTransitGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTransitGatewayResponse =
      zio.aws.ec2.model.ModifyTransitGatewayResponse(
        transitGateway.map(value => value.asEditable)
      )
    def transitGateway: Option[zio.aws.ec2.model.TransitGateway.ReadOnly]
    def getTransitGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGateway.ReadOnly] =
      AwsError.unwrapOptionField("transitGateway", transitGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayResponse
  ) extends zio.aws.ec2.model.ModifyTransitGatewayResponse.ReadOnly {
    override val transitGateway
        : Option[zio.aws.ec2.model.TransitGateway.ReadOnly] = scala
      .Option(impl.transitGateway())
      .map(value => zio.aws.ec2.model.TransitGateway.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayResponse
  ): zio.aws.ec2.model.ModifyTransitGatewayResponse.ReadOnly = new Wrapper(impl)
}
