package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  Integer,
  CapacityReservationFleetId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ModifyCapacityReservationFleetRequest(
    capacityReservationFleetId: CapacityReservationFleetId,
    totalTargetCapacity: Option[Integer] = None,
    endDate: Option[MillisecondDateTime] = None,
    removeEndDate: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest = {
    import ModifyCapacityReservationFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest
      .builder()
      .capacityReservationFleetId(
        CapacityReservationFleetId.unwrap(
          capacityReservationFleetId
        ): java.lang.String
      )
      .optionallyWith(
        totalTargetCapacity.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.totalTargetCapacity)
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(removeEndDate.map(value => value: java.lang.Boolean))(
        _.removeEndDate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyCapacityReservationFleetRequest.ReadOnly =
    zio.aws.ec2.model.ModifyCapacityReservationFleetRequest
      .wrap(buildAwsValue())
}
object ModifyCapacityReservationFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyCapacityReservationFleetRequest =
      zio.aws.ec2.model.ModifyCapacityReservationFleetRequest(
        capacityReservationFleetId,
        totalTargetCapacity.map(value => value),
        endDate.map(value => value),
        removeEndDate.map(value => value)
      )
    def capacityReservationFleetId: CapacityReservationFleetId
    def totalTargetCapacity: Option[Integer]
    def endDate: Option[MillisecondDateTime]
    def removeEndDate: Option[Boolean]
    def getCapacityReservationFleetId
        : ZIO[Any, Nothing, CapacityReservationFleetId] =
      ZIO.succeed(capacityReservationFleetId)
    def getTotalTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalTargetCapacity", totalTargetCapacity)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getRemoveEndDate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("removeEndDate", removeEndDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest
  ) extends zio.aws.ec2.model.ModifyCapacityReservationFleetRequest.ReadOnly {
    override val capacityReservationFleetId: CapacityReservationFleetId =
      zio.aws.ec2.model.primitives
        .CapacityReservationFleetId(impl.capacityReservationFleetId())
    override val totalTargetCapacity: Option[Integer] = scala
      .Option(impl.totalTargetCapacity())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val endDate: Option[MillisecondDateTime] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val removeEndDate: Option[Boolean] =
      scala.Option(impl.removeEndDate()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationFleetRequest
  ): zio.aws.ec2.model.ModifyCapacityReservationFleetRequest.ReadOnly =
    new Wrapper(impl)
}
