package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateConfig(
    launchTemplateSpecification: Option[
      zio.aws.ec2.model.FleetLaunchTemplateSpecification
    ] = None,
    overrides: Option[Iterable[zio.aws.ec2.model.LaunchTemplateOverrides]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig = {
    import LaunchTemplateConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig
      .builder()
      .optionallyWith(
        launchTemplateSpecification.map(value => value.buildAwsValue())
      )(_.launchTemplateSpecification)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateConfig.wrap(buildAwsValue())
}
object LaunchTemplateConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateConfig =
      zio.aws.ec2.model.LaunchTemplateConfig(
        launchTemplateSpecification.map(value => value.asEditable),
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def launchTemplateSpecification
        : Option[zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly]
    def overrides
        : Option[List[zio.aws.ec2.model.LaunchTemplateOverrides.ReadOnly]]
    def getLaunchTemplateSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchTemplateSpecification",
      launchTemplateSpecification
    )
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateOverrides.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig
  ) extends zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly {
    override val launchTemplateSpecification
        : Option[zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly] =
      scala
        .Option(impl.launchTemplateSpecification())
        .map(value =>
          zio.aws.ec2.model.FleetLaunchTemplateSpecification.wrap(value)
        )
    override val overrides
        : Option[List[zio.aws.ec2.model.LaunchTemplateOverrides.ReadOnly]] =
      scala
        .Option(impl.overrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LaunchTemplateOverrides.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig
  ): zio.aws.ec2.model.LaunchTemplateConfig.ReadOnly = new Wrapper(impl)
}
