package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LastError(
    message: Option[String] = None,
    code: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.LastError = {
    import LastError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LastError
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LastError.ReadOnly =
    zio.aws.ec2.model.LastError.wrap(buildAwsValue())
}
object LastError {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.LastError] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LastError = zio.aws.ec2.model
      .LastError(message.map(value => value), code.map(value => value))
    def message: Option[String]
    def code: Option[String]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LastError
  ) extends zio.aws.ec2.model.LastError.ReadOnly {
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val code: Option[String] =
      scala.Option(impl.code()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LastError
  ): zio.aws.ec2.model.LastError.ReadOnly = new Wrapper(impl)
}
