package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IpamPoolCidr(
    cidr: Option[String] = None,
    state: Option[zio.aws.ec2.model.IpamPoolCidrState] = None,
    failureReason: Option[zio.aws.ec2.model.IpamPoolCidrFailureReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamPoolCidr = {
    import IpamPoolCidr.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamPoolCidr
      .builder()
      .optionallyWith(cidr.map(value => value: java.lang.String))(_.cidr)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(failureReason.map(value => value.buildAwsValue()))(
        _.failureReason
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamPoolCidr.ReadOnly =
    zio.aws.ec2.model.IpamPoolCidr.wrap(buildAwsValue())
}
object IpamPoolCidr {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IpamPoolCidr] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamPoolCidr =
      zio.aws.ec2.model.IpamPoolCidr(
        cidr.map(value => value),
        state.map(value => value),
        failureReason.map(value => value.asEditable)
      )
    def cidr: Option[String]
    def state: Option[zio.aws.ec2.model.IpamPoolCidrState]
    def failureReason
        : Option[zio.aws.ec2.model.IpamPoolCidrFailureReason.ReadOnly]
    def getCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidr", cidr)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolCidrState] =
      AwsError.unwrapOptionField("state", state)
    def getFailureReason: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IpamPoolCidrFailureReason.ReadOnly
    ] = AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamPoolCidr
  ) extends zio.aws.ec2.model.IpamPoolCidr.ReadOnly {
    override val cidr: Option[String] =
      scala.Option(impl.cidr()).map(value => value: String)
    override val state: Option[zio.aws.ec2.model.IpamPoolCidrState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.IpamPoolCidrState.wrap(value))
    override val failureReason
        : Option[zio.aws.ec2.model.IpamPoolCidrFailureReason.ReadOnly] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.ec2.model.IpamPoolCidrFailureReason.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamPoolCidr
  ): zio.aws.ec2.model.IpamPoolCidr.ReadOnly = new Wrapper(impl)
}
